Ext.define('Photoalbum.view.Detail', {
	extend : 'Ext.Panel',
	xtype  : 'photoalbum-detail',
	id: 'detail',

    config : {
    	floating        : true,
        modal           : false,
        left			: 0,
        top				: 0,
        width           : (0.5*screen.width),
        height          : (0.5*screen.height),
        layout			: 'fit',
        items: [
            {
	        	xtype: 'tabpanel',
	        	tabBarPosition: 'top',
	            activeItem: 2,
	            items: [
	                {
	                    xtype: 'photoalbum-detail-info'
	                },
	                {
	                    xtype: 'photoalbum-detail-comments'
	                },
	                {
	                	xtype: 'photoalbum-detail-map'
	                },
	                {
	                	xtype: 'carousel',
	                	id: 'detailaffinity',
	                	title: unescape('%C4hnliche'),
	                	layout: 'fit',
	                	items: [{
		                	html: ' '
		                },{
		                	html: ' '
		                },{
		                	html: ' '
		                },{
		                	html: ' '
		                },{
		                	html: ' '
		                }]	
	                }
	            ],
	            listeners: {
	            	activate: function() {
	            		var tabbar = this.getTabBar();
//	            		tabbar.getAt(3).hide();
	            		tabbar.add({
	                        xtype: 'button',
	                        id: 'delpic',
	                        iconMask: true,
	                        iconCls: 'trash',
	                        iconAlign: 'right',
	                        docked: 'right',
	            		});
	            	}
	            }
            }
        ],
    },
    
    mapload: function() {
		this.setModal(true);
		this.child('tabpanel').setActiveItem(0);
		this.hide();
	},
	
	loadingmask: false,
	
	showAffinityTab: function(affinity) {
		if(affinity.length>0) {
			this.child('tabpanel').getTabBar().getAt(3).show();
			for(var i=0; i<affinity.length && i<5; i++) {
				this.down('carousel').getAt(i+1).setHtml('<div style="text-align:center;"><img src="'+affinity[i]+'"></div>');
			}
		}
	},
	
	hideAffinityTab: function() {
		this.child('tabpanel').getTabBar().getAt(3).hide();
		this.down('carousel').setActiveItem(0);
		for(var i=1; i<this.down('carousel').getItems().length; i++) {
			this.down('carousel').getAt(i).setHtml(' ');
		}
	}
	
});